<?php
/* --------------------------------------------------------------
   SpecificParcelServiceRequested.php 2020-03-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Events;

use Gambio\Admin\ParcelService\Interfaces\ParcelServiceId;

/**
 * Class SpecificParcelServiceRequested
 *
 * @package Gambio\Admin\ParcelService\Events
 */
class SpecificParcelServiceRequested
{
    /**
     * @var ParcelServiceId
     */
    private $parcelServiceId;
    
    
    /**
     * SpecificParcelServiceRequested constructor.
     *
     * @param ParcelServiceId $parcelServiceId
     */
    private function __construct(ParcelServiceId $parcelServiceId)
    {
        $this->parcelServiceId = $parcelServiceId;
    }
    
    
    /**
     * @param ParcelServiceId $parcelServiceId
     *
     * @return SpecificParcelServiceRequested
     */
    public static function create(ParcelServiceId $parcelServiceId): SpecificParcelServiceRequested
    {
        return new self($parcelServiceId);
    }
    
    
    /**
     * @return ParcelServiceId
     */
    public function parcelServiceId(): ParcelServiceId
    {
        return $this->parcelServiceId;
    }
    
    
    /**
     * @param ParcelServiceId $parcelServiceId
     */
    public function replaceParcelServiceId(ParcelServiceId $parcelServiceId): void
    {
        $this->parcelServiceId = $parcelServiceId;
    }
}